var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { exec } from 'node:child_process';
import fs from 'node:fs/promises';
import path from 'node:path';
import { promisify } from 'node:util';
import { logger } from '../../shared/logger.js';
const execAsync = promisify(exec);
export const isGitInstalled = (...args_1) => __awaiter(void 0, [...args_1], void 0, function* (deps = {
    execAsync,
}) {
    try {
        const result = yield deps.execAsync('git --version');
        return !result.stderr;
    }
    catch (error) {
        logger.trace('Git is not installed:', error.message);
        return false;
    }
});
export const execGitShallowClone = (url_1, directory_1, remoteBranch_1, ...args_1) => __awaiter(void 0, [url_1, directory_1, remoteBranch_1, ...args_1], void 0, function* (url, directory, remoteBranch, deps = {
    execAsync,
}) {
    if (remoteBranch) {
        yield deps.execAsync(`git -C ${directory} init`);
        yield deps.execAsync(`git -C ${directory} remote add origin ${url}`);
        try {
            yield deps.execAsync(`git -C ${directory} fetch --depth 1 origin ${remoteBranch}`);
            yield deps.execAsync(`git -C ${directory} checkout FETCH_HEAD`);
        }
        catch (err) {
            // git fetch --depth 1 origin <short SHA> always throws "couldn't find remote ref" error
            const isRefNotfoundError = err instanceof Error && err.message.includes(`couldn't find remote ref ${remoteBranch}`);
            if (!isRefNotfoundError) {
                // Rethrow error as nothing else we can do
                throw err;
            }
            // Short SHA detection - matches a hexadecimal string of 4 to 39 characters
            // If the string matches this regex, it MIGHT be a short SHA
            // If the string doesn't match, it is DEFINITELY NOT a short SHA
            const isNotShortSHA = !remoteBranch.match(/^[0-9a-f]{4,39}$/i);
            if (isNotShortSHA) {
                // Rethrow error as nothing else we can do
                throw err;
            }
            // Maybe the error is due to a short SHA, let's try again
            // Can't use --depth 1 here as we need to fetch the specific commit
            yield deps.execAsync(`git -C ${directory} fetch origin`);
            yield deps.execAsync(`git -C ${directory} checkout ${remoteBranch}`);
        }
    }
    else {
        yield deps.execAsync(`git clone --depth 1 ${url} ${directory}`);
    }
    // Clean up .git directory
    yield fs.rm(path.join(directory, '.git'), { recursive: true, force: true });
});
//# sourceMappingURL=gitCommand.js.map